<?php
    
    use yii\db\Migration;
    
    class m170606_114809_article_related_product extends Migration
    {
        public function safeUp()
        {
            $this->createTable(
                'article_to_product',
                [
                    'article_id' => $this->integer()
                                         ->notNull(),
                    'product_id' => $this->integer()
                                         ->notNull(),
                ]
            );
            $this->addPrimaryKey(
                'article_to_product_pk',
                'article_to_product',
                [
                    'article_id',
                    'product_id',
                ]
            );
            $this->addForeignKey(
                'article_id_fkey',
                'article_to_product',
                'article_id',
                'blog_article',
                'id',
                'CASCADE',
                'CASCADE'
            );
            $this->addForeignKey(
                'product_id_fkey',
                'article_to_product',
                'product_id',
                'product',
                'id',
                'CASCADE',
                'CASCADE'
            );
        }
        
        public function safeDown()
        {
            $this->dropTable('article_to_product');
        }
    }
