<?php
    
    namespace artbox\weblog\models;

    use artbox\core\behaviors\ManyToManyBehavior;
    use artbox\core\models\Image;
    use artbox\webcomment\models\CommentModel;
    use yii\behaviors\TimestampBehavior;
    use yii\db\ActiveRecord;
    use artbox\core\behaviors\LanguageBehavior;
    use artbox\core\models\Language;
    use yii\db\ActiveQuery;
    use yii\db\Query;
    use yii\helpers\Url;
    use yii\web\Request;

    /**
     * This is the model class for table "blog_article".
     *
     * @property integer                          $id
     * @property Image                            $image
     * @property integer                          $created_at
     * @property integer                          $updated_at
     * @property integer                          $deleted_at
     * @property integer                          $sort
     * @property boolean                          $status
     * @property integer                          $author_id
     * @property integer                          $image_id
     * @property ArticleLang[]                    $blogArticleLangs
     * @property Language[]                       $languages
     * @property Article[]                        $relatedBlogArticles
     * @property Article[]                        $articles
     * @property Category[]                       $categories
     * @property Category                         $category
     * @property Tag[]                            $tags
     * @property \artbox\catalog\models\Product[] $relatedProducts
     * * * From language behavior *
     * @property ArticleLang                      $lang
     * @property ArticleLang[]                    $langs
     * @property ArticleLang                      $objectLang
     * @property string                           $ownerKey
     * @property string                           $langKey
     * @property ArticleLang[]                    $modelLangs
     * @property bool                             $transactionStatus
     * @method string           getOwnerKey()
     * @method void             setOwnerKey( string $value )
     * @method string           getLangKey()
     * @method void             setLangKey( string $value )
     * @method ActiveQuery      getLangs()
     * @method ActiveQuery      getLang( integer $language_id )
     * @method ArticleLang[]    generateLangs()
     * @method void             loadLangs( Request $request )
     * @method bool             linkLangs()
     * @method bool             saveLangs()
     * @method bool             getTransactionStatus()
     * @method bool loadWithLangs( Request $request )
     * @method bool saveWithLangs()
     * * End language behavior *
     * @method void linkMany( string $link, array $models )
     */
    class Article extends ActiveRecord
    {
        public $categoryIds = [];
    
        public $tagIds = [];
    
        public $articleIds = [];
    
        public $productIds = [];
        
        /**
         * @inheritdoc
         */
        public static function tableName()
        {
            return 'blog_article';
        }
    
        public function behaviors()
        {
            return [
                [
                    'class' => TimestampBehavior::className(),
                ],
                'language' => [
                    'class' => LanguageBehavior::className(),
                ],
                [
                    'class' => ManyToManyBehavior::className(),
                ],
            ];
        }
        /**
         * @inheritdoc
         */
        public function rules()
        {
            return [
                [
                    [
                        'created_at',
                        'updated_at',
                        'deleted_at',
                        'sort',
                        'author_id',
                        'image_id',
                    ],
                    'integer',
                ],
                [
                    [ 'status' ],
                    'boolean',
                ],
            ];
        }
    
        /**
         * @inheritdoc
         */
        public function attributeLabels()
        {
            return [
                'id'         => 'ID',
                'image'      => 'Image',
                'created_at' => 'Created At',
                'updated_at' => 'Updated At',
                'deleted_at' => 'Deleted At',
                'sort'       => 'Sort',
                'status'     => 'Status',
                'author_id'  => 'Author ID',
            ];
        }
    
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getRelatedBlogArticles()
        {
            return $this->hasMany(Article::className(), [ 'id' => 'related_blog_article_id' ])
                        ->viaTable('blog_article_to_article', [ 'blog_article_id' => 'id' ]);
        }
    
        /**
         * @return Query
         */
        public function getRelatedProducts()
        {
            if (class_exists('\artbox\catalog\models\Product')) {
                return $this->hasMany('\artbox\catalog\models\Product', [ 'id' => 'product_id' ])
                            ->via('articleToProduct');
            } else {
                return ( new Query() )->where('1 = 0');
            }
        }

        public function getCommentsCount()
        {

            if (class_exists('\artbox\webcomment\models\CommentModel')) {
                $comments = CommentModel::find()->where("status = 1 and entity = 'artbox\weblog\models\Article' and entity_id = ".$this->id)->count();
                return $comments;
            } else {
                return null;
            }
        }
    
        /**
         * @return Query
         */
        public function getArticleToProduct()
        {

            if (class_exists('\artbox\catalog\models\Product')) {
                return $this->hasMany(ArticleToProduct::className(), [ 'article_id' => 'id' ]);
            } else {
                return ( new Query() )->where('1 = 0');
            }
        }
        
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getImage()
        {
            return $this->hasOne(Image::className(), [ 'id' => 'image_id' ]);
        }
    
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getArticles()
        {
            return $this->hasMany(Article::className(), [ 'id' => 'blog_article_id' ])
                        ->viaTable('blog_article_to_article', [ 'related_blog_article_id' => 'id' ]);
        }
    
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getCategories()
        {
            return $this->hasMany(Category::className(), [ 'id' => 'blog_category_id' ])
                        ->viaTable('blog_article_to_category', [ 'blog_article_id' => 'id' ]);
        }
    
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getCategory()
        {
            return $this->hasOne(Category::className(), [ 'id' => 'blog_category_id' ])
                        ->viaTable('blog_article_to_category', [ 'blog_article_id' => 'id' ]);
        }
    
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getTags()
        {
            return $this->hasMany(Tag::className(), [ 'id' => 'blog_tag_id' ])
                        ->viaTable('blog_article_to_tag', [ 'blog_article_id' => 'id' ]);
        }
    }
