<?php
    
    namespace artbox\weblog\models;

    use artbox\core\behaviors\SlugBehavior;
    use artbox\core\models\Alias;
    use artbox\core\models\Language;
    use yii\db\ActiveRecord;

    /**
     * This is the model class for table "blog_article_lang".
     
     *
*@property integer        $id
     * @property integer  $blog_article_id
     * @property integer  $language_id
     * @property string   $title
     * @property string   $body
     * @property string   $body_preview
     * @property string   $meta_title
     * @property string   $meta_description
     * @property string   $h1
     * @property string   $seo_text
     * @property Article  $article
     * @property Language $language
     * @property Alias    $alias
     */
    class ArticleLang extends ActiveRecord
    {
        /**
         * @inheritdoc
         */
        public static function tableName()
        {
            return 'blog_article_lang';
        }
    
        public function behaviors()
        {
            return [
                'slug' => [
                    'class'  => SlugBehavior::className(),
                    'action' => 'blog/article',
                    'params' => [
                        'id' => 'blog_article_id',
                    ],
                    'fields' => [
                        'title' => 'Article title',
                    ],
                ],
            ];
        }
    
        /**
         * @inheritdoc
         */
        public function rules()
        {
            return [
                [
                    [
                        'blog_article_id',
                        'language_id',
                        'title',
                    ],
                    'required',
                ],
                [
                    [
                        'blog_article_id',
                        'language_id',
                    ],
                    'integer',
                ],
                [
                    [
                        'body',
                        'body_preview',
                    ],
                    'string',
                ],
                [
                    [
                        'title',
                    ],
                    'string',
                    'max' => 255,
                ],

                [
                    [
                        'blog_article_id',
                        'language_id',
                    ],
                    'unique',
                    'targetAttribute' => [
                        'blog_article_id',
                        'language_id',
                    ],
                    'message'         => 'The combination of Blog Article ID and Language ID has already been taken.',
                ],
                [
                    [ 'blog_article_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => Article::className(),
                    'targetAttribute' => [ 'blog_article_id' => 'id' ],
                ],
                [
                    [ 'language_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => Language::className(),
                    'targetAttribute' => [ 'language_id' => 'id' ],
                ],
            ];
        }
    
        /**
         * @inheritdoc
         */
        public function attributeLabels()
        {
            return [
                'id'               => 'ID',
                'blog_article_id'  => 'Blog Article ID',
                'language_id'      => 'Language ID',
                'title'            => 'Title',
                'body'             => 'Body',
                'body_preview'     => 'Body Preview',
                'alias'            => 'Alias',
                'meta_title'       => 'Meta Title',
                'meta_description' => 'Meta Description',
                'h1'               => 'H1',
                'seo_text'         => 'Seo Text',
            ];
        }
    
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getArticle()
        {
            return $this->hasOne(Article::className(), [ 'id' => 'blog_article_id' ]);
        }
    
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getLanguage()
        {
            return $this->hasOne(Language::className(), [ 'id' => 'language_id' ]);
        }
    
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getAlias()
        {
            return $this->hasOne(Alias::className(), [ 'id' => 'alias_id' ]);
        }
    }
