<?php
    
    namespace artbox\weblog\models;
    
    use yii\base\Model;
    use yii\data\ActiveDataProvider;
    
    /**
     * BlogArticleSearch represents the model behind the search form about `artweb\artbox\blog\models\BlogArticle`.
     */
    class ArticleSearch extends Article
    {
        /**
         * @var string
         */
        public $title;
    
        public $tag;
    
        public $category;
        
        /**
         * @inheritdoc
         */
        public function rules()
        {
            return [
                [
                    [
                        'id',
                        'deleted_at',
                        'sort',
                        'author_id',
                    ],
                    'integer',
                ],
                [
                    [ 'status' ],
                    'boolean',
                ],
                [
                    [
                        'title',
                        'tag',
                        'category',
                    ],
                    'string',
                ],
            ];
        }
        
        /**
         * @inheritdoc
         */
        public function behaviors()
        {
            return [];
        }
        
        /**
         * @inheritdoc
         */
        public function scenarios()
        {
            // bypass scenarios() implementation in the parent class
            return Model::scenarios();
        }
        
        /**
         * Creates data provider instance with search query applied
         *
         * @param array $params
         *
         * @return ActiveDataProvider
         */
        public function search($params)
        {
            $query = Article::find()
                            ->joinWith(
                                [
                                    'lang',

                                ]
                            )
                            ->with(
                                [
                                    'tags.lang',
                                    'categories.lang',
                                ]
                            );
            
            // add conditions that should always apply here
            
            $dataProvider = new ActiveDataProvider(
                [
                    'query' => $query,
                    'sort'  => [
                        'attributes' => [
                            'id',
                            'created_at',
                            'updated_at',
                            'title' => [
                                'asc'  => [ 'blog_article_lang.title' => SORT_ASC ],
                                'desc' => [ 'blog_article_lang.title' => SORT_DESC ],
                            ],
                        ],
                    ],
                ]
            );
            
            $this->load($params);
            
            if (!$this->validate()) {
                // uncomment the following line if you do not want to return any records when validation fails
                // $query->where('0=1');
                return $dataProvider;
            }
            
            // grid filtering conditions
            $query->andFilterWhere(
                [
                    'blog_article.id'        => $this->id,
                    'blog_article.status'    => $this->status,
                    'author_id' => $this->author_id,
                ]
            );
            
            $query->andFilterWhere(
                [
                    'ilike',
                    'blog_article_lang.title',
                    $this->title,
                ]
            );
    
            $query->andFilterWhere(
                [
                    'ilike',
                    'blog_tag_lang.label',
                    $this->tag,
                ]
            );
    
            $query->andFilterWhere(
                [
                    'ilike',
                    'blog_category_lang.title',
                    $this->category,
                ]
            );
            
            return $dataProvider;
        }
    }
