<?php
    
    namespace artbox\weblog\models;
    
    use yii\db\ActiveRecord;
    
    /**
     * This is the model class for table "article_to_product".
     *
     * @property integer                        $article_id
     * @property integer                        $product_id
     * @property \artbox\weblog\models\Article  $article
     * @property \artbox\catalog\models\Product $product
     */
    class ArticleToProduct extends ActiveRecord
    {
        /**
         * @inheritdoc
         */
        public static function tableName()
        {
            return 'article_to_product';
        }
        
        /**
         * @inheritdoc
         */
        public function rules()
        {
            return [
                [
                    [
                        'article_id',
                        'product_id',
                    ],
                    'integer',
                ],
                [
                    [
                        'article_id',
                        'product_id',
                    ],
                    'required',
                ],
                [
                    [
                        'article_id',
                    ],
                    'exist',
                    'targetClass'     => '\artbox\weblog\models\Article',
                    'targetAttribute' => 'id',
                ],
                [
                    [
                        'product_id',
                    ],
                    'exist',
                    'targetClass'     => '\artbox\catalog\models\Product',
                    'targetAttribute' => 'id',
                ],
            ];
        }
        
        /**
         * @inheritdoc
         */
        public function attributeLabels()
        {
            return [
                'article_id' => \Yii::t('blog', 'Article ID'),
                'product_id' => \Yii::t('blog', 'Product ID'),
            ];
        }
        
        /**
         * Get article query
         *
         * @return \yii\db\ActiveQuery
         */
        public function getArticle()
        {
            return $this->hasOne('\artbox\weblog\models\Article', [ 'id' => 'article_id' ]);
        }
        
        /**
         * Get product query
         *
         * @return \yii\db\ActiveQuery
         */
        public function getProduct()
        {
            return $this->hasOne('\artbox\catalog\models\Article', [ 'id' => 'product_id' ]);
        }
    }
