<?php
    
    namespace artbox\weblog\models;

    use artbox\core\models\Image;
    use yii\db\ActiveRecord;
    use artbox\core\behaviors\LanguageBehavior;
    use artbox\core\models\Language;
    use yii\db\ActiveQuery;
    use yii\web\Request;

    /**
     * This is the model class for table "blog_category".
     *
     * @property integer        $id
     * @property integer        $sort
     * @property integer        $parent_id
     * @property boolean        $status
     * @property Article[]      $articles
     * @property CategoryLang[] $blogCategoryLangs
     * @property Language[]     $languages
     * @property Category       $parent
     * @property Image          $image
     * @property integer        $image_id
     * * From language behavior *
     * @property CategoryLang   $lang
     * @property CategoryLang[] $langs
     * @property CategoryLang   $objectLang
     * @property string         $ownerKey
     * @property string         $langKey
     * @property CategoryLang[] $modelLangs
     * @property bool           $transactionStatus
     * @method string           getOwnerKey()
     * @method void             setOwnerKey( string $value )
     * @method string           getLangKey()
     * @method void             setLangKey( string $value )
     * @method ActiveQuery      getLangs()
     * @method ActiveQuery      getLang( integer $language_id )
     * @method CategoryLang[]    generateLangs()
     * @method void             loadLangs( Request $request )
     * @method bool             linkLangs()
     * @method bool             saveLangs()
     * @method bool             getTransactionStatus()
     * @method bool loadWithLangs( Request $request )
     * @method bool saveWithLangs()
     * * End language behavior *
     * * From SaveImgBehavior *
     * @property string|null    $imageFile
     * @property string|null    $imageUrl
     * @method string|null getImageFile( int $field )
     * @method string|null getImageUrl( int $field )
     * * End SaveImgBehavior
     */
    class Category extends ActiveRecord
    {
        /**
         * @inheritdoc
         */
        public static function tableName()
        {
            return 'blog_category';
        }
    
        /**
         * @inheritdoc
         */
        public function behaviors()
        {
            return [
                'language' => [
                    'class' => LanguageBehavior::className(),
                ],
            ];
        }
    
        /**
         * @inheritdoc
         */
        public function rules()
        {
            return [
                [
                    [
                        'sort',
                        'parent_id',
                        'image_id',
                    ],
                    'integer',
                ],
                [
                    [ 'status' ],
                    'boolean',
                ],
                [
                    [ 'parent_id' ],
                    'default',
                    'value' => 0,
                ],
            ];
        }
    
        /**
         * @inheritdoc
         */
        public function attributeLabels()
        {
            return [
                'id'        => 'ID',
                'sort'      => 'Sort',
                'image'     => 'Image',
                'parent_id' => 'Parent ID',
                'status'    => 'Status',
            ];
        }
    
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getArticles()
        {
            return $this->hasMany(Article::className(), [ 'id' => 'blog_article_id' ])
                        ->viaTable('blog_article_to_category', [ 'blog_category_id' => 'id' ]);
        }
    
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getParent()
        {
            return $this->hasOne(Category::className(), [ 'id' => 'parent_id' ]);
        }
    
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getImage()
        {
            return $this->hasOne(Image::className(), [ 'id' => 'image_id' ]);
        }
    }
