<?php
    
    namespace artbox\weblog\models;

    use artbox\core\behaviors\SlugBehavior;
    use artbox\core\models\Alias;
    use yii\db\ActiveRecord;
    use artbox\core\models\Language;

    /**
     * This is the model class for table "blog_category_lang".
     *
     * @property integer  $id
     * @property integer  $blog_category_id
     * @property integer  $language_id
     * @property string   $title
     * @property string   $description
     * @property Category $category
     * @property Language $language
     */
    class CategoryLang extends ActiveRecord
    {
        /**
         * @inheritdoc
         */
        public static function tableName()
        {
            return 'blog_category_lang';
        }
    
        public function behaviors()
        {
            return [
                'slug' => [
                    'class'  => SlugBehavior::className(),
                    'action' => 'blog/category',
                    'params' => [
                        'id' => 'blog_category_id',
                    ],
                    'fields' => [
                        'title' => 'Category title',
                    ],
                ],
            ];
        }
    
        /**
         * @inheritdoc
         */
        public function rules()
        {
            return [
                [
                    [
                        'blog_category_id',
                        'language_id',
                        'title',
                    ],
                    'required',
                ],
                [
                    [
                        'blog_category_id',
                        'language_id',
                    ],
                    'integer',
                ],
                [
                    [ 'description' ],
                    'string',
                ],
                [
                    [
                        'title',
                    ],
                    'string',
                    'max' => 255,
                ],
                [
                    [
                        'blog_category_id',
                        'language_id',
                    ],
                    'unique',
                    'targetAttribute' => [
                        'blog_category_id',
                        'language_id',
                    ],
                    'message'         => 'The combination of Blog Category ID and Language ID has already been taken.',
                ],
                [
                    [ 'blog_category_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => Category::className(),
                    'targetAttribute' => [ 'blog_category_id' => 'id' ],
                ],
                [
                    [ 'language_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => Language::className(),
                    'targetAttribute' => [ 'language_id' => 'id' ],
                ],
            ];
        }
    
        /**
         * @inheritdoc
         */
        public function attributeLabels()
        {
            return [
                'id'               => 'ID',
                'blog_category_id' => 'Blog Category ID',
                'language_id'      => 'Language ID',
                'title'            => 'Title',
                'alias'            => 'Alias',
                'description'      => 'Description',
                'meta_title'       => 'Meta Title',
                'meta_description' => 'Meta Description',
                'h1'               => 'H1',
                'seo_text'         => 'Seo Text',
            ];
        }
    
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getCategory()
        {
            return $this->hasOne(Category::className(), [ 'id' => 'blog_category_id' ]);
        }
    
        public function getAlias()
        {
            return $this->hasOne(Alias::className(), [ 'id' => 'alias_id' ]);
        }
        
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getLanguage()
        {
            return $this->hasOne(Language::className(), [ 'id' => 'language_id' ]);
        }
    }
