<?php
    
    namespace artbox\weblog\models;
    
    use yii\db\ActiveRecord;
    use artbox\core\behaviors\LanguageBehavior;
    use artbox\core\models\Language;
    use yii\db\ActiveQuery;
    use yii\web\Request;
    
    /**
     * This is the model class for table "blog_tag".
     *
     * @property integer    $id
     * @property Article[]  $articles
     * @property TagLang[]  $blogTagLangs
     * @property Language[] $languages
     * * From language behavior *
     * @property TagLang    $lang
     * @property TagLang[]  $langs
     * @property TagLang    $objectLang
     * @property string     $ownerKey
     * @property string     $langKey
     * @property TagLang[]  $modelLangs
     * @property bool       $transactionStatus
     * @method string           getOwnerKey()
     * @method void             setOwnerKey( string $value )
     * @method string           getLangKey()
     * @method void             setLangKey( string $value )
     * @method ActiveQuery      getLangs()
     * @method ActiveQuery      getLang( integer $language_id )
     * @method TagLang[]    generateLangs()
     * @method void             loadLangs( Request $request )
     * @method bool             linkLangs()
     * @method bool             saveLangs()
     * @method bool             getTransactionStatus()
     * @method bool saveWithLangs()
     * @method bool loadWithLangs( Request $request )
     * * End language behavior *
     */
    class Tag extends ActiveRecord
    {
        /**
         * @inheritdoc
         */
        public static function tableName()
        {
            return 'blog_tag';
        }
        
        /**
         * @inheritdoc
         */
        public function behaviors()
        {
            return [
                'language' => [
                    'class' => LanguageBehavior::className(),
                ],
            ];
        }
        
        /**
         * @inheritdoc
         */
        public function rules()
        {
            return [
                [
                    [ 'id' ],
                    'integer',
                ],
            ];
        }
        
        /**
         * @inheritdoc
         */
        public function attributeLabels()
        {
            return [
                'id' => 'ID',
            ];
        }
        
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getArticles()
        {
            return $this->hasMany(Article::className(), [ 'id' => 'blog_article_id' ])
                        ->viaTable('blog_article_to_tag', [ 'blog_tag_id' => 'id' ]);
        }
    }
