<?php
    
    namespace artbox\weblog\models;

    use artbox\core\behaviors\SlugBehavior;
    use artbox\core\models\Alias;
    use artbox\core\models\Language;
    use yii\db\ActiveRecord;

    /**
     * This is the model class for table "blog_tag_lang".
     *
     * @property integer  $id
     * @property integer  $blog_tag_id
     * @property integer  $language_id
     * @property string   $label
     * @property Tag      $blogTag
     * @property Language $language
     */
    class TagLang extends ActiveRecord
    {
    
        /**
         * @inheritdoc
         */
        public static function tableName()
        {
            return 'blog_tag_lang';
        }
    
        /**
         * @inheritdoc
         */
        public function behaviors()
        {
            return [
                'slug' => [
                    'class'       => SlugBehavior::className(),
                    'action'      => 'blog/tag',
                    'params'      => [
                        'id' => 'blog_tag_id',
                    ],
                    'fields'      => [
                        'label' => \Yii::t('blog', 'Tag label'),
                    ],
                    'inAttribute' => 'label',
                ],
            ];
        }
    
        /**
         * @inheritdoc
         */
        public function rules()
        {
            return [
                [
                    [
                        'blog_tag_id',
                        'language_id',
                    ],
                    'required',
                ],
                [
                    [
                        'blog_tag_id',
                        'language_id',
                    ],
                    'integer',
                ],
                [
                    [ 'label' ],
                    'string',
                    'max' => 255,
                ],
                [
                    [
                        'blog_tag_id',
                        'language_id',
                    ],
                    'unique',
                    'targetAttribute' => [
                        'blog_tag_id',
                        'language_id',
                    ],
                    'message'         => 'The combination of Blog Tag ID and Language ID has already been taken.',
                ],
                [
                    [ 'blog_tag_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => Tag::className(),
                    'targetAttribute' => [ 'blog_tag_id' => 'id' ],
                ],
                [
                    [ 'language_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => Language::className(),
                    'targetAttribute' => [ 'language_id' => 'id' ],
                ],
            ];
        }
    
        /**
         * @inheritdoc
         */
        public function attributeLabels()
        {
            return [
                'id'          => 'ID',
                'blog_tag_id' => 'Blog Tag ID',
                'language_id' => 'Language ID',
                'label'       => 'Label',
            ];
        }
    
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getTag()
        {
            return $this->hasOne(Tag::className(), [ 'id' => 'blog_tag_id' ]);
        }
    
        public function getAlias()
        {
            return $this->hasOne(Alias::className(), [ 'id' => 'alias_id' ]);
        }
        
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getLanguage()
        {
            return $this->hasOne(Language::className(), [ 'id' => 'language_id' ]);
        }
    }
