<?php
    
    use artbox\core\components\imagemanager\components\ImageManagerInputWidget;
    use artbox\weblog\models\Article;
    use artbox\weblog\models\ArticleLang;
    use artbox\weblog\models\Category;
    use artbox\weblog\models\Tag;
    use kartik\select2\Select2;
    use yii\helpers\Html;
    use yii\helpers\Url;
    use yii\web\View;
    use yii\widgets\ActiveForm;
    use artbox\core\widgets\LanguageForm;
    use yii\web\JsExpression;
    
    /**
     * @var View          $this
     * @var Article       $model
     * @var ActiveForm    $form
     * @var ArticleLang[] $modelLangs
     * @var Category[]    $categories
     * @var Tag[]         $tags
     * @var array         $products
     * @var array         $articles
     */
?>

<div class="blog-article-form">
    
    <?php $form = ActiveForm::begin(
        [
            'options' => [ 'enctype' => 'multipart/form-data' ],
        ]
    ); ?>
    
    <?php
        echo LanguageForm::widget(
            [
                'modelLangs' => $modelLangs,
                'formView'   => '@artbox/weblog/views/blog-article/_form_language',
                'form'       => $form,
            ]
        );
    ?>
  
  <div class="form-group">
    <label class="control-label"><?= \Yii::t('blog', 'Categories'); ?></label>
      <?php
          echo Select2::widget(
              [
                  'name'          => 'categoryIds',
                  'options'       => [
                      'placeholder' => \Yii::t('blog', 'Search for a categories ...'),
                      'multiple'    => true,
    
                  ],
    
                  'value'             => array_keys($model->categoryIds),
                  'data'              => $model->categoryIds,
                  'toggleAllSettings' => [
                      'selectLabel' => false,
                  ],
                  'pluginOptions'     => [
                      'allowClear'         => true,
                      'minimumInputLength' => 3,
                      'language'           => [
                          'errorLoading' => new JsExpression(
                              "function () { return 'Waiting for results...'; }"
                          ),
                      ],
                      'ajax'               => [
                          'url'      => Url::to([ '/blog-category/list' ]),
                          'dataType' => 'json',
                          'data'     => new JsExpression(
                              'function(params) { 
                                    return {
                                        q:params.term
                                    }; 
                                 }'
                          ),
                      ],
                      'escapeMarkup'       => new JsExpression(
                          'function (markup) {
                                return markup; 
                             }'
                      ),
                      'templateResult'     => new JsExpression(
                          'function (brand) { 
                                return brand.text; 
                             }'
                      ),
                      'templateSelection'  => new JsExpression(
                          'function (brand) {
                                return brand.text; 
                             }'
                      ),
                  ],
              ]
          );
      ?>
  </div>
  
  <div class="form-group">
    <label class="control-label"><?= \Yii::t('blog', 'Tags'); ?></label>
      <?php
          echo Select2::widget(
              [
                  'name'              => 'tagIds',
                  'options'           => [
                      'placeholder' => \Yii::t('blog', 'Search for a tags ...'),
                      'multiple'    => true,
                  ],
                  'toggleAllSettings' => [
                      'selectLabel' => false,
                  ],
                  'value'             => array_keys($model->tagIds),
                  'data'              => $model->tagIds,
                  'pluginOptions'     => [
                      'allowClear'         => true,
                      'minimumInputLength' => 3,
                      'language'           => [
                          'errorLoading' => new JsExpression(
                              "function () { return 'Waiting for results...'; }"
                          ),
                      ],
                      'ajax'               => [
                          'url'      => Url::to([ '/blog-tag/list' ]),
                          'dataType' => 'json',
                          'data'     => new JsExpression(
                              'function(params) { 
                                    return {
                                        q:params.term
                                    }; 
                                 }'
                          ),
                      ],
                      'escapeMarkup'       => new JsExpression(
                          'function (markup) {
                                return markup; 
                             }'
                      ),
                      'templateResult'     => new JsExpression(
                          'function (brand) { 
                                return brand.text; 
                             }'
                      ),
                      'templateSelection'  => new JsExpression(
                          'function (brand) {
                                return brand.text; 
                             }'
                      ),
                  ],
              ]
          );
      ?>
  </div>
    
    <?= $form->field($model, 'image_id')
             ->widget(
                 ImageManagerInputWidget::className(),
                 [
                     'aspectRatio'                  => ( 16 / 9 ),
                     //set the aspect ratio
                     'showPreview'                  => true,
                     //false to hide the preview
                     'showDeletePickedImageConfirm' => false,
                     //on true show warning before detach image
                 ]
             ); ?>
  
  <div class="form-group">
    <label class="control-label"><?= \Yii::t('blog', 'Articles'); ?></label>
      <?php
          if ($model->isNewRecord) {
              $condition = '';
          } else {
              $condition = ', id: ' . $model->id;
          }
          echo Select2::widget(
              [
                  'name'              => 'articleIds',
                  'options'           => [
                      'placeholder' => \Yii::t('blog', 'Search for an articles ...'),
                      'multiple'    => true,
                  ],
                  'toggleAllSettings' => [
                      'selectLabel' => false,
                  ],
                  'value'             => array_keys($model->articleIds),
                  'data'              => $model->articleIds,
                  'pluginOptions'     => [
                      'allowClear'         => true,
                      'minimumInputLength' => 3,
                      'language'           => [
                          'errorLoading' => new JsExpression(
                              "function () { return 'Waiting for results...'; }"
                          ),
                      ],
                      'ajax'               => [
                          'url'      => Url::to([ '/blog-article/list' ]),
                          'dataType' => 'json',
                          'data'     => new JsExpression(
                              'function(params) { 
                                    return {
                                        q:params.term' . $condition . '
                                    }; 
                                 }'
                          ),
                      ],
                      'escapeMarkup'       => new JsExpression(
                          'function (markup) {
                                return markup; 
                             }'
                      ),
                      'templateResult'     => new JsExpression(
                          'function (brand) { 
                                return brand.text; 
                             }'
                      ),
                      'templateSelection'  => new JsExpression(
                          'function (brand) {
                                return brand.text; 
                             }'
                      ),
                  ],
              ]
          );
      ?>
  </div>
    <?php
        if (class_exists('\artbox\catalog\models\Product')) {
            ?>
          <div class="form-group">
            <label class="control-label"><?= \Yii::t('blog', 'Products'); ?></label>
              <?php
                  echo Select2::widget(
                      [
                          'name'              => 'productIds',
                          'options'           => [
                              'placeholder' => \Yii::t('blog', 'Search for products ...'),
                              'multiple'    => true,
                          ],
                          'toggleAllSettings' => [
                              'selectLabel' => false,
                          ],
                          'value'             => array_keys($model->productIds),
                          'data'              => $model->productIds,
                          'pluginOptions'     => [
                              'allowClear'         => true,
                              'minimumInputLength' => 3,
                              'language'           => [
                                  'errorLoading' => new JsExpression(
                                      "function () { return 'Waiting for results...'; }"
                                  ),
                              ],
                              'ajax'               => [
                                  'url'      => Url::to([ '/product/list' ]),
                                  'dataType' => 'json',
                                  'data'     => new JsExpression(
                                      'function(params) {
                                    return {
                                        q:params.term
                                    };
                                 }'
                                  ),
                              ],
                              'escapeMarkup'       => new JsExpression(
                                  'function (markup) {
                                return markup;
                             }'
                              ),
                              'templateResult'     => new JsExpression(
                                  'function (product) {
                                return product.text;
                             }'
                              ),
                              'templateSelection'  => new JsExpression(
                                  'function (product) {
                                return product.text;
                             }'
                              ),
                          ],
                      ]
                  );
              ?>
          </div>
            <?php
        }
    ?>
    
    <?= $form->field($model, 'sort')
             ->textInput() ?>
    
    <?= $form->field($model, 'status')
             ->checkbox(
                 [
                     'class' => 'flat',
                 ]
             ) ?>
    
    <?= $form->field($model, 'author_id')
             ->textInput() ?>
  
  <div class="form-group">
      <?= Html::submitButton(
          $model->isNewRecord ? 'Create' : 'Update',
          [ 'class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary' ]
      ) ?>
  </div>
    
    <?php ActiveForm::end(); ?>

</div>
