<?php
    use artbox\core\helpers\SlugifyDecorator;
    use artbox\weblog\models\ArticleLang;
    use artbox\core\models\Language;
    use dosamigos\tinymce\TinyMce;
    use yii\helpers\Url;
    use yii\web\JsExpression;
    use yii\web\View;
    use yii\widgets\ActiveForm;
    
    /**
     * @var ArticleLang $model_lang
     * @var Language    $language
     * @var ActiveForm  $form
     * @var View        $this
     */
?>
<?php
    $attributeField = $form->field($model_lang, '[' . $language->id . ']title')
                           ->textInput([ 'maxlength' => true ]);
    echo $attributeField;
?>

<?= SlugifyDecorator::decorate(
    $form->field($model_lang, '[' . $language->id . ']aliasValue'),
    [ '/alias/slugify' ],
    $attributeField,
    false,
    $language->id
)
                    ->textInput([ 'maxlength' => true ]); ?>

<?= $form->field($model_lang, '[' . $language->id . ']body')
         ->widget(
             TinyMce::className(),
             [
                 'options'       => [ 'rows' => 30 ],
                 'language'      => 'ru',
                 'clientOptions' => [
                     'file_browser_callback' => new JsExpression(
                         "function(field_name, url, type, win) {
window.open('" . Url::to(
                             [
                                 'imagemanager/manager',
                                 'view-mode'   => 'iframe',
                                 'select-type' => 'tinymce',
                             ]
                         ) . "&tag_name='+field_name,'','width=800,height=540 ,toolbar=no,status=no,menubar=no,scrollbars=no,resizable=no');
}"
                     ),
                     'plugins'               => [
                         "advlist autolink lists link charmap print preview anchor",
                         "searchreplace visualblocks code fullscreen",
                         "insertdatetime media table contextmenu paste image",
                     ],
                     'toolbar'               => "undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image | code",
                     'image_advtab'          => true,
                 ],
             ]
         ); ?>

<?= $form->field($model_lang, '[' . $language->id . ']body_preview')
         ->textarea(
             [
                 'rows' => '10',
             ]
         ) ?>
