<?php
    
    use artbox\weblog\models\Article;
    use artbox\weblog\models\ArticleLang;
    use yii\web\View;
    use yiister\gentelella\widgets\Panel;
    
    /**
     * @var View          $this
     * @var Article       $model
     * @var ArticleLang[] $modelLangs
     * @var array         $products
     * @var array         $articles
     */
    
    $this->title = \Yii::t('blog', 'Create Blog Article');
    $this->params[ 'breadcrumbs' ][] = [
        'label' => \Yii::t('blog', 'Blog Articles'),
        'url'   => [ 'index' ],
    ];
    $this->params[ 'breadcrumbs' ][] = $this->title;
?>
<div class="blog-article-create">
    
    <?php $panel = Panel::begin(
        [
            'header' => $this->title,
        ]
    ); ?>
    
    <?= $this->render(
        '_form',
        [
            'model'      => $model,
            'modelLangs' => $modelLangs,
        ]
    ) ?>
    
    <?php $panel::end(); ?>

</div>
