<?php
    
    use artbox\weblog\models\Article;
    use artbox\weblog\models\ArticleSearch;
    use artbox\weblog\models\Category;
    use artbox\weblog\models\Tag;
    use yii\data\ActiveDataProvider;
    use yii\helpers\ArrayHelper;
    use yii\helpers\Html;
    use yii\grid\GridView;
    use yii\web\View;
    use yiister\gentelella\widgets\Panel;
    
    /**
     * @var View               $this
     * @var ArticleSearch      $searchModel
     * @var ActiveDataProvider $dataProvider
     */
    
    $this->title = \Yii::t('blog', 'Blog Articles');
    $this->params[ 'breadcrumbs' ][] = $this->title;
?>
<div class="blog-article-index">
    
    <?php $panel = Panel::begin(
        [
            'header' => $this->title,
        ]
    ); ?>
  <p>
      <?= Html::a(
          \Yii::t('app', 'create_item', [ 'item' => 'Blog Article' ]),
          [ 'create' ],
          [ 'class' => 'btn btn-success' ]
      ) ?>
  </p>
    <?= GridView::widget(
        [
            'dataProvider' => $dataProvider,
            'filterModel'  => $searchModel,
            'columns'      => [
                'id',
                [
                    'attribute' => 'title',
                    'value'     => 'lang.title',
                ],
                [
                    'attribute' => 'category',
                    'label'     => \Yii::t('blog', 'Categories'),
                    'value'     => function (Article $model) {
                        if (empty($model->categories)) {
                            return \Yii::$app->formatter->asText(null);
                        } else {
                            return implode(
                                ',<br>',
                                ArrayHelper::getColumn(
                                    $model->categories,
                                    function (Category $category) {
                                        return $category->lang->title;
                                    }
                                )
                            );
                        }
                    },
                    'format'    => 'html',
                ],
                [
                    'attribute' => 'tag',
                    'label'     => \Yii::t('blog', 'Tags'),
                    'value'     => function (Article $model) {
                        if (empty($model->tags)) {
                            return \Yii::$app->formatter->asText(null);
                        } else {
                            return implode(
                                ',<br>',
                                ArrayHelper::getColumn(
                                    $model->tags,
                                    function (Tag $tag) {
                                        return $tag->lang->label;
                                    }
                                )
                            );
                        }
                    },
                    'format'    => 'html',
                ],
                [
                    'attribute' => 'image_id',
                    'value'     => function (Article $model) {
                        if (empty($model->image_id)) {
                            return '';
                        } else {
                            return $model->image->getImg(
                                [
                                    'width' => '300px',
                                ]
                            );
                        }
                    },
                    'format'    => 'html',
                ],
                [
                    'attribute' => 'status',
                    'value'     => function (Article $model) {
                        return ( !$model->status ) ? \Yii::t('blog', 'Not active') : \Yii::t('blog', 'Active');
                    },
                    'filter'    => [
                        0 => \Yii::t('blog', 'Not active'),
                        1 => \Yii::t('blog', 'Active'),
                    ],
                ],
                'created_at:date',
                'updated_at:date',
                [ 'class' => 'yii\grid\ActionColumn' ],
            ],
        ]
    ); ?>
    
    <?php $panel::end(); ?>

</div>
