<?php
    
    use artbox\weblog\models\Article;
    use artbox\weblog\models\ArticleLang;
    use yii\web\View;
    use yiister\gentelella\widgets\Panel;
    
    /**
     * @var View          $this
     * @var Article       $model
     * @var ArticleLang[] $modelLangs
     */
    
    $this->title = \Yii::t('blog', 'Update Blog Article: ') . $model->lang->title;
    $this->params[ 'breadcrumbs' ][] = [
        'label' => \Yii::t('blog', 'Blog Articles'),
        'url'   => [ 'index' ],
    ];
    $this->params[ 'breadcrumbs' ][] = [
        'label' => $model->lang->title,
        'url'   => [
            'view',
            'id' => $model->id,
        ],
    ];
    $this->params[ 'breadcrumbs' ][] = \Yii::t('blog', 'Update');
?>
<div class="blog-article-update">
    
    <?php $panel = Panel::begin(
        [
            'header' => $this->title,
        ]
    ); ?>
    
    <?= $this->render(
        '_form',
        [
            'model'      => $model,
            'modelLangs' => $modelLangs,
        ]
    ) ?>
    
    <?php $panel::end(); ?>

</div>
