<?php
    
    use artbox\weblog\models\Article;
    use yii\helpers\Html;
    use yii\web\View;
    use yii\widgets\DetailView;
    use yiister\gentelella\widgets\Panel;
    
    /**
     * @var View    $this
     * @var Article $model
     */
    
    $this->title = $model->lang->title;
    $this->params[ 'breadcrumbs' ][] = [
        'label' => \Yii::t('blog', 'Blog Articles'),
        'url'   => [ 'index' ],
    ];
    $this->params[ 'breadcrumbs' ][] = $this->title;
?>
<div class="blog-article-view">
    
    <?php $panel = Panel::begin(
        [
            'header' => $this->title,
        ]
    ); ?>
  
  <p>
      <?= Html::a(
          'Update',
          [
              'update',
              'id' => $model->id,
          ],
          [ 'class' => 'btn btn-primary' ]
      ) ?>
      <?= Html::a(
          'Delete',
          [
              'delete',
              'id' => $model->id,
          ],
          [
              'class' => 'btn btn-danger',
              'data'  => [
                  'confirm' => 'Are you sure you want to delete this item?',
                  'method'  => 'post',
              ],
          ]
      ) ?>
  </p>
    
    <?= DetailView::widget(
        [
            'model'      => $model,
            'attributes' => [
                'id',
                [
                    'attribute' => 'image_id',
                    'value'     => function (Article $model) {
                        if (empty($model->image_id)) {
                            return '';
                        } else {
                            return $model->image->getImg(
                                [
                                    'width' => '500px',
                                ]
                            );
                        }
                    },
                    'format'    => 'html',
                ],
                'created_at:date',
                'updated_at:date',
                [
                    'attribute' => 'status',
                    'value'     => ( !$model->status ) ? \Yii::t('blog', 'Not active') : \Yii::t('blog', 'Active'),
                ],
                'lang.body:html',
            ],
        ]
    ) ?>
    
    <?php $panel::end(); ?>

</div>
