<?php
    
    use artbox\core\components\imagemanager\components\ImageManagerInputWidget;
    use artbox\core\widgets\LanguageForm;
    use artbox\weblog\models\Category;
    use artbox\weblog\models\CategoryLang;
    use kartik\select2\Select2;
    use yii\helpers\Html;
    use yii\web\View;
    use yii\widgets\ActiveForm;
    
    /**
     * @var View           $this
     * @var Category       $model
     * @var ActiveForm     $form
     * @var CategoryLang[] $modelLangs
     * @var array          $parentCategories
     */
?>

<div class="blog-category-form">
    
    <?php $form = ActiveForm::begin(
        [
            'options' => [ 'enctype' => 'multipart/form-data' ],
        
        ]
    ); ?>
    
    <?php
        echo LanguageForm::widget(
            [
                'modelLangs' => $modelLangs,
                'formView'   => '@artbox/weblog/views/blog-category/_form_language',
                'form'       => $form,
            ]
        );
    ?>
    
    <?= $form->field($model, 'image_id')
             ->widget(
                 ImageManagerInputWidget::className(),
                 [
                     'aspectRatio'                  => ( 16 / 9 ),
                     //set the aspect ratio
                     'showPreview'                  => true,
                     //false to hide the preview
                     'showDeletePickedImageConfirm' => false,
                     //on true show warning before detach image
                 ]
             ); ?>
    
    <?= $form->field($model, 'sort')
             ->textInput() ?>
    
    <?php echo $form->field($model, 'parent_id')
                    ->widget(
                        Select2::className(),
                        [
                            'data'          => $parentCategories,
                            'options'       => [ 'placeholder' => \Yii::t('blog', 'Has no parent rubric') ],
                            'pluginOptions' => [
                                'allowClear' => true,
                            ],
                        ]
                    );
    ?>
    
    <?= $form->field($model, 'status')
             ->checkbox(
                 [
                     'class' => 'flat',
                 ]
             ) ?>
  
  <div class="form-group">
      <?= Html::submitButton(
          $model->isNewRecord ? 'Create' : 'Update',
          [ 'class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary' ]
      ) ?>
  </div>
    
    <?php ActiveForm::end(); ?>

</div>
