<?php
    
    use artbox\core\helpers\SlugifyDecorator;
    use artbox\weblog\models\CategoryLang;
    use artbox\core\models\Language;
    use yii\web\View;
    use yii\widgets\ActiveForm;
    
    /**
     * @var CategoryLang $model_lang
     * @var Language     $language
     * @var ActiveForm   $form
     * @var View         $this
     */
?>
<?= $attributeField = $form->field($model_lang, '[' . $language->id . ']title')
                           ->textInput([ 'maxlength' => true ]); ?>

<?= SlugifyDecorator::decorate(
    $form->field($model_lang, '[' . $language->id . ']aliasValue'),
    [ '/alias/slugify' ],
    $attributeField,
    false,
    $language->id
)
                    ->textInput([ 'maxlength' => true ]); ?>

<?= $form->field($model_lang, '[' . $language->id . ']description')
         ->textarea(
             [
                 'rows' => '10',
             ]
         ) ?>
