<?php
    
    use artbox\weblog\models\Category;
    use artbox\weblog\models\CategorySearch;
    use yii\data\ActiveDataProvider;
    use yii\helpers\Html;
    use yii\grid\GridView;
    use yii\web\View;
    use yiister\gentelella\widgets\Panel;
    
    /**
     * @var View               $this
     * @var CategorySearch     $searchModel
     * @var ActiveDataProvider $dataProvider
     */
    
    $this->title = \Yii::t('blog', 'Blog Categories');
    $this->params[ 'breadcrumbs' ][] = $this->title;
?>
<div class="blog-category-index">
    
    <?php $panel = Panel::begin(
        [
            'header' => $this->title,
        ]
    ); ?>
  
  <p>
      <?= Html::a(\Yii::t('blog', 'Create Blog Category'), [ 'create' ], [ 'class' => 'btn btn-success' ]) ?>
  </p>
    <?= GridView::widget(
        [
            'dataProvider' => $dataProvider,
            'filterModel'  => $searchModel,
            'columns'      => [
                'id',
                [
                    'attribute' => 'title',
                    'value'     => 'lang.title',
                ],
                [
                    'attribute' => 'image_id',
                    'value'     => function (Category $model) {
                        if (empty($model->image_id)) {
                            return '';
                        } else {
                        }
                        return $model->image->getImg(
                            [
                                'width' => '300px',
                            ]
                        );
                    },
                    'format'    => 'html',
                ],
                [
                    'label' => \Yii::t('blog', 'Parent category'),
                    'value' => function (Category $model) {
                        if (!empty($model->parent)) {
                            return $model->parent->lang->title;
                        } else {
                            return false;
                        }
                    },
                ],
                [
                    'attribute' => 'status',
                    'value'     => function (Category $model) {
                        return ( !$model->status ) ? \Yii::t('blog', 'Not active') : \Yii::t('blog', 'Active');
                    },
                    'filter'    => [
                        0 => \Yii::t('blog', 'Not active'),
                        1 => \Yii::t('blog', 'Active'),
                    ],
                ],
                [ 'class' => 'yii\grid\ActionColumn' ],
            ],
        ]
    ); ?>
    
    <?php $panel::end(); ?>

</div>
