<?php
    
    use artbox\weblog\models\Category;
    use artbox\weblog\models\CategoryLang;
    use yii\web\View;
    use yiister\gentelella\widgets\Panel;
    
    /**
     * @var View         $this
     * @var Category     $model
     * @var CategoryLang $modelLangs
     * @var array        $parentCategories
     */
    
    $this->title = \Yii::t('blog', 'Update Blog Category: ') . $model->lang->title;
    $this->params[ 'breadcrumbs' ][] = [
        'label' => \Yii::t('blog', 'Blog Categories'),
        'url'   => [ 'index' ],
    ];
    $this->params[ 'breadcrumbs' ][] = [
        'label' => $model->lang->title,
        'url'   => [
            'view',
            'id' => $model->id,
        ],
    ];
    $this->params[ 'breadcrumbs' ][] = \Yii::t('blog', 'Update');
?>
<div class="blog-category-update">
    
    <?php $panel = Panel::begin(
        [
            'header' => $this->title,
        ]
    ); ?>
    
    <?= $this->render(
        '_form',
        [
            'model'            => $model,
            'modelLangs'       => $modelLangs,
            'parentCategories' => $parentCategories,
        ]
    ) ?>
    
    <?php $panel::end(); ?>

</div>
