<?php
    
    use artbox\core\widgets\LanguageForm;
    use artbox\weblog\models\Tag;
    use artbox\weblog\models\TagLang;
    use yii\helpers\Html;
    use yii\web\View;
    use yii\widgets\ActiveForm;

    
    /**
     * @var View       $this
     * @var Tag        $model
     * @var ActiveForm $form
     * @var TagLang[]  $modelLangs
     */
?>

<div class="blog-tag-form">
    
    <?php $form = ActiveForm::begin(); ?>
    
    <?php
        echo LanguageForm::widget(
            [
                'modelLangs' => $modelLangs,
                'formView'   => '@artbox/weblog/views/blog-tag/_form_language',
                'form'       => $form,
            ]
        );
    ?>
    
    <div class="form-group">
        <?= Html::submitButton(
            $model->isNewRecord ? 'Create' : 'Update',
            [ 'class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary' ]
        ) ?>
    </div>
    
    <?php ActiveForm::end(); ?>

</div>
