<?php
    
    use artbox\core\helpers\SlugifyDecorator;
    use artbox\core\models\Language;
    use artbox\weblog\models\ArticleLang;
    use yii\web\View;
    use yii\widgets\ActiveForm;
    
    /**
     * @var ArticleLang $model_lang
     * @var Language    $language
     * @var ActiveForm  $form
     * @var View        $this
     */
?>
<?= $attributeField = $form->field($model_lang, '[' . $language->id . ']label')
                           ->textInput([ 'maxlength' => true ]); ?>

<?= SlugifyDecorator::decorate(
    $form->field($model_lang, '[' . $language->id . ']aliasValue'),
    [ '/alias/slugify' ],
    $attributeField,
    false,
    $language->id
)
                    ->textInput([ 'maxlength' => true ]); ?>
