<?php
    
    use artbox\weblog\models\TagSearch;
    use yii\data\ActiveDataProvider;
    use yii\helpers\Html;
    use yii\grid\GridView;
    use yii\web\View;
    use yiister\gentelella\widgets\Panel;
    
    /**
     * @var View               $this
     * @var TagSearch          $searchModel
     * @var ActiveDataProvider $dataProvider
     */
    
    $this->title = \Yii::t('blog', 'Blog Tags');
    $this->params[ 'breadcrumbs' ][] = $this->title;
?>
<div class="blog-tag-index">
    
    <?php $panel = Panel::begin(
        [
            'header' => $this->title,
        ]
    ); ?>
  
  <p>
      <?= Html::a(\Yii::t('blog', 'Create Blog Tag'), [ 'create' ], [ 'class' => 'btn btn-success' ]) ?>
  </p>
    <?= GridView::widget(
        [
            'dataProvider' => $dataProvider,
            'filterModel'  => $searchModel,
            'columns'      => [
                'id',
                [
                    'attribute' => 'label',
                    'value'     => 'lang.label',
                ],
                [
                    'class' => 'yii\grid\ActionColumn',
                ],
            ],
        ]
    ); ?>
    
    <?php $panel::end(); ?>

</div>
