<?php
    
    use artbox\weblog\models\Tag;
    use artbox\weblog\models\TagLang;
    use yii\web\View;
    use yiister\gentelella\widgets\Panel;
    
    /**
     * @var View      $this
     * @var TagLang[] $modelLangs
     * @var Tag       $model
     */
    
    $this->title = \Yii::t('blog', 'Update Blog Tag: ') . $model->lang->label;
    $this->params[ 'breadcrumbs' ][] = [
        'label' => \Yii::t('blog', 'Blog Tags'),
        'url'   => [ 'index' ],
    ];
    $this->params[ 'breadcrumbs' ][] = [
        'label' => $model->lang->label,
        'url'   => [
            'view',
            'id' => $model->id,
        ],
    ];
    $this->params[ 'breadcrumbs' ][] = \Yii::t('blog', 'Update');
?>
<div class="blog-tag-update">
    
    <?php $panel = Panel::begin(
        [
            'header' => $this->title,
        ]
    ); ?>
    
    <?= $this->render(
        '_form',
        [
            'model'      => $model,
            'modelLangs' => $modelLangs,
        ]
    ) ?>
    
    <?php $panel::end(); ?>
  
</div>
