<?php
    
    use artbox\weblog\models\Tag;
    use yii\helpers\Html;
    use yii\web\View;
    use yii\widgets\DetailView;
    use yiister\gentelella\widgets\Panel;
    
    /**
     * @var View $this
     * @var Tag  $model
     */
    
    $this->title = $model->lang->label;
    $this->params[ 'breadcrumbs' ][] = [
        'label' => \Yii::t('blog', 'Blog Tags'),
        'url'   => [ 'index' ],
    ];
    $this->params[ 'breadcrumbs' ][] = $this->title;
?>
<div class="blog-tag-view">
    
    <?php $panel = Panel::begin(
        [
            'header' => $this->title,
        ]
    ); ?>
  
  <p>
      <?= Html::a(
          'Update',
          [
              'update',
              'id' => $model->id,
          ],
          [ 'class' => 'btn btn-primary' ]
      ) ?>
      <?= Html::a(
          'Delete',
          [
              'delete',
              'id' => $model->id,
          ],
          [
              'class' => 'btn btn-danger',
              'data'  => [
                  'confirm' => 'Are you sure you want to delete this item?',
                  'method'  => 'post',
              ],
          ]
      ) ?>
  </p>
    
    <?= DetailView::widget(
        [
            'model'      => $model,
            'attributes' => [
                'id',
                'lang.label',
            ],
        ]
    ) ?>
    
    <?php $panel::end(); ?>

</div>
