(function($) {

    var $pswp = $('.pswp')[0];
    var image = [];

    $('.reviews_gallery-wr').each( function() {
        var $pic     = $(this),
            getItems = function() {
                var items = [];
                $pic.find('figure a').each(function() {
                    var $href   = $(this).attr('href'),
                        $size   = $(this).data('size').split('x'),
                        $width  = $size[0],
                        $height = $size[1];

                    if(!($(this).data('type') == 'video')){
                        var item = {
                            src : $href,
                            w   : $width,
                            h   : $height
                        }
                    } else {
                        item = {
                            html: '<div class="wrapper">' + $(this).data('video') + '</div>'
                        };

                    }



                    items.push(item);
                });
                return items;
            }

        var items = getItems();

        $.each(items, function(index, value) {
            image[index]     = new Image();
            image[index].src = value['src'];
        });

        $pic.on('click', 'figure', function(event) {
            event.preventDefault();
            var $index = $(this).index();
            var options = {
                index: $index,
                bgOpacity: 0.7,
                showHideOpacity: true,
                shareEl: false
            }

            var lightBox = new PhotoSwipe($pswp, PhotoSwipeUI_Default, items, options);
            lightBox.init();
        });
    });

})(jQuery);