$(
    function() {
        $(document)
            .on(
                'submit', '#get-itform', function(e) {
                    e.preventDefault();
                    var dataArray = $(this)
                        .serializeArray();
                    dataArray.forEach(
                        function(elem) {
                            console.log(elem.name);
                        }
                    );

                    var form = this;
                    if (validate(dataArray)) {
                        $.ajax(
                            {
                                url: 'submit.php',
                                type: "POST",
                                data: dataArray,
                                success: function(data) {
                                    //if (data.status) {
                                        form.reset();
                                        var pos = ($(window)
                                                       .scrollTop() + 30 + 50);
                                        $('.forms_')
                                            .animate(
                                                {
                                                    opacity: 0,
                                                    top: '0'
                                                }, 200, function() {
                                                    $(this)
                                                        .css('display', 'none');
                                                    //                                            $('#overlay').fadeOut(400);
                                                }
                                            );
                                        $('#success-modal')
                                            .css('display', 'block')
                                            .animate(
                                                {
                                                    opacity: 1,
                                                    top: pos
                                                }, 200
                                            );
                                    //}
                                }
                            }
                        );
                    }
                    return false;
                }
            );

        $(document)
            .on(
                'blur', '.form-control', function() {
                    var formData = $('#get-itform')
                        .serializeArray();
                    validate(formData);
                }
            );

        function validate(array) {
            var isValid = true;
            var re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
            array.forEach(
                function(element) {
                    switch (element.name) {
                        case 'email' :
                            if ((element.value.length === 0) || !re.test(element.value.toLowerCase())) {
                                $('#email-block')
                                    .addClass('has-error');
                                isValid = false;
                            } else {
                                $('#email-block')
                                    .removeClass('has-error');
                            }
                            break;
                    }
                }
            );

            return isValid;
        }
    }
);