<?php
    
    namespace artbox\stock\models;
    
    use artbox\core\behaviors\SlugBehavior;
    use artbox\core\models\Alias;
    use artbox\core\models\Language;
    use yii\db\ActiveRecord;
    
    /**
     * This is the model class for table "shop_lang".
     *
     * @property integer  $shop_id
     * @property integer  $language_id
     * @property string   $title
     * @property integer  $alias_id
     * @property string   $description
     * @property Alias    $alias
     * @property Language $language
     * @property Shop     $shop
     */
    class ShopLang extends ActiveRecord
    {
        /**
         * @inheritdoc
         */
        public static function tableName()
        {
            return 'shop_lang';
        }
        
        /**
         * @inheritdoc
         */
        public function behaviors()
        {
            return [
                'slug' => [
                    'class'  => SlugBehavior::className(),
                    'action' => 'shop/view',
                    'params' => [
                        'id' => 'shop_id',
                    ],
                    'fields' => [
                        'title'       => \Yii::t('stock', 'Title'),
                        'description' => \Yii::t('stock', 'Description'),
                        'address'     => \Yii::t('stock', 'Address'),
                    ],
                ],
            ];
        }
        public function rules()
        {
            return [
                [
                    [
                        'shop_id',
                        'language_id',
                        'title',
                    ],
                    'required',
                ],
                [
                    [
                        'shop_id',
                        'language_id',
                        'alias_id',
                    ],
                    'integer',
                ],
                [
                    [ 'description' ],
                    'string',
                ],
                [
                    [ 'title' ],
                    'string',
                    'max' => 255,
                ],
                [
                    [ 'address' ],
                    'string',
                    'max' => 255,
                ],
                [
                    [ 'alias_id' ],
                    'unique',
                ],
                [
                    [ 'alias_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => Alias::className(),
                    'targetAttribute' => [ 'alias_id' => 'id' ],
                ],
                [
                    [ 'language_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => Language::className(),
                    'targetAttribute' => [ 'language_id' => 'id' ],
                ],
                [
                    [ 'shop_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => Shop::className(),
                    'targetAttribute' => [ 'shop_id' => 'id' ],
                ],
            ];
        }
        
        /**
         * @inheritdoc
         */
        public function attributeLabels()
        {
            return [
                'shop_id'     => 'Shop ID',
                'language_id' => 'Language ID',
                'title'       => \Yii::t('stock', 'Title'),
                'alias_id'    => 'Alias ID',
                'description' => \Yii::t('stock', 'Description'),
                'address'     => \Yii::t('stock', 'Address'),
            ];
        }
        
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getAlias()
        {
            return $this->hasOne(Alias::className(), [ 'id' => 'alias_id' ]);
        }
        
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getLanguage()
        {
            return $this->hasOne(Language::className(), [ 'id' => 'language_id' ]);
        }
        
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getShop()
        {
            return $this->hasOne(Shop::className(), [ 'id' => 'shop_id' ]);
        }
    }
