<?php
    
    namespace artbox\stock\models;
    
    use yii\db\ActiveRecord;
    use artbox\catalog\models\Variant;
    
    /**
     * This is the model class for table "variant_to_shop".
     *
     * @property integer $variant_id
     * @property integer $shop_id
     * @property integer $count
     * @property Shop    $shop
     * @property Variant $variant
     */
    class VariantToShop extends ActiveRecord
    {
        /**
         * @inheritdoc
         */
        public static function tableName()
        {
            return 'variant_to_shop';
        }
        
        /**
         * @inheritdoc
         */
        public function rules()
        {
            return [
                [
                    [
                        'variant_id',
                        'shop_id',
                    ],
                    'required',
                ],
                [
                    [
                        'variant_id',
                        'shop_id',
                        'count',
                    ],
                    'integer',
                ],
                [
                    [ 'shop_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => Shop::className(),
                    'targetAttribute' => [ 'shop_id' => 'id' ],
                ],
                [
                    [ 'variant_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => Variant::className(),
                    'targetAttribute' => [ 'variant_id' => 'id' ],
                ],
            ];
        }
        
        /**
         * @inheritdoc
         */
        public function attributeLabels()
        {
            return [
                'variant_id' => 'Variant ID',
                'shop_id'    => 'Shop ID',
                'count'      => \Yii::t('stock', 'Count'),
            ];
        }
        
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getShop()
        {
            return $this->hasOne(Shop::className(), [ 'id' => 'shop_id' ]);
        }
        
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getVariant()
        {
            return $this->hasOne(Variant::className(), [ 'id' => 'variant_id' ]);
        }
        /*
        public function afterSave($insert, $changedAttributes)
        {
            parent::afterSave($insert, $changedAttributes); // TODO: Change the autogenerated stub
            
            $variant = $this->variant;
            if ($variant->stock - $changedAttributes['count'] >= 0){
                $variant->stock = $variant->stock - $changedAttributes['count'] + $this->count;
            }else{
                $variant->stock = $this->count;
            }
            $variant->save();
            
        }
        )*/
    
    }
