<?php
    use artbox\stock\models\CityLang;
    use artbox\core\helpers\SlugifyDecorator;
    use artbox\core\models\Language;
    use dosamigos\tinymce\TinyMce;
    use yii\web\View;
    use yii\widgets\ActiveForm;
    
    /**
     * @var CityLang   $model_lang
     * @var Language   $language
     * @var ActiveForm $form
     * @var View       $this
     */
?>
<?php
    $attributeField = $form->field($model_lang, '[' . $language->id . ']title')
                           ->textInput(
                               [
                                   'maxlength' => true,
                                   'id'        => 'city_title',
                               ]
                           );
    echo $attributeField;
?>
    <div id="map_canvas" style="height: 300px;"></div>
<?= SlugifyDecorator::decorate(
    $form->field($model_lang, '[' . $language->id . ']aliasValue'),
    [ '/alias/slugify' ],
    $attributeField,
    false,
    $language->id
)
                    ->textInput([ 'maxlength' => true ]); ?>

<?php
    echo $form->field($model_lang, '[' . $language->id . ']description')
              ->widget(
                  TinyMce::className(),
                  [
                      'options'       => [ 'rows' => 6 ],
                      'language'      => 'ru',
                      'clientOptions' => [
                          'file_browser_callback' => new yii\web\JsExpression(
                              "function(field_name, url, type, win) {
window.open('" . yii\helpers\Url::to(
                                  [
                                      'imagemanager/manager',
                                      'view-mode'   => 'iframe',
                                      'select-type' => 'tinymce',
                                  ]
                              ) . "&tag_name='+field_name,'','width=800,height=540 ,toolbar=no,status=no,menubar=no,scrollbars=no,resizable=no');
}"
                          ),
                          'plugins'               => [
                              "advlist autolink lists link charmap print preview anchor",
                              "searchreplace visualblocks code fullscreen",
                              "insertdatetime media table contextmenu paste image",
                          ],
                          'toolbar'               => "undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image | code",
                      ],
                  ]
              );
?>