<?php
    
    use yii\helpers\Html;
    use yii\grid\GridView;
    use yiister\gentelella\widgets\Panel;
    use yii\helpers\Url;
   
    
    /* @var $this yii\web\View */
    /* @var $dataProvider yii\data\ActiveDataProvider */
    
    $this->title = 'Shops';
    $this->params[ 'breadcrumbs' ][] = \Yii::t('stock', $this->title);
?>
<div class="shop-index">
    <?php
        $xPanel = Panel::begin(
            [
                'header' => \Yii::t('stock', Html::encode($this->title)),
            ]
        );
    ?>
  <h1><?= \Yii::t('stock', Html::encode($this->title)) ?></h1>
  
  <p>
      <?= Html::a(\Yii::t('stock', 'Create Shop'), [ 'create' ], [ 'class' => 'btn btn-success' ]) ?>
  </p>
    <?= GridView::widget(
        [
            'dataProvider' => $dataProvider,
            'columns'      => [
                [ 'class' => 'yii\grid\SerialColumn' ],
                
                'id',
                [
                    'attribute' => \Yii::t('stock', 'Address'),
                    'value'     => 'lang.address',
                ],
                'sort',
                'status:boolean',
                
                [ 'class' => 'yii\grid\ActionColumn',
                  'template' => '{view} {update} {delete}{link}',
                'buttons' => [
                'link' => function ($url,$model,$key) {
                    return Html::a('Товары', Url::to([
                                                         '/variant-count/index',
                                                         'shop_id' => $model->id
                                                     ]));
                },
                'icon'  => 'gift',
                ],
                ],
            ],
        ]
    ); ?>
    <?php
        $xPanel::end();
    ?>
</div>
