<?php
    
    use yii\helpers\Html;
    use yiister\gentelella\widgets\Panel;
    
    /* @var $this yii\web\View */
    /* @var $model artbox\stock\models\Shop */
    /* @var $modelLangs artbox\stock\models\ShopLang */
    
    $this->title = Yii::t(
            'catalog',
            'Update {modelClass}: ',
            [
                'modelClass' => 'Shop',
            ]
        ) . $model->lang->title;
    $this->params[ 'breadcrumbs' ][] = [
        'label' => Yii::t('stock', 'Shop'),
        'url'   => [ 'index' ],
    ];
    $this->params[ 'breadcrumbs' ][] = [
        'label' => $model->lang->title,
        'url'   => [
            'view',
            'id' => $model->id,
        ],
    ];
    $this->params[ 'breadcrumbs' ][] = Yii::t('stock', 'Update'); ?>
<div class="shop-update">
    <?php
        $xPanel = Panel::begin(
            [
                'header' => \Yii::t('stock', Html::encode($this->title)),
            ]
        );
    ?>
  <h1><?= Html::encode($this->title) ?></h1>
    
    <?= $this->render(
        '_form',
        [
            'model'      => $model,
            'modelLangs' => $modelLangs,
        ]
    ) ?>
    <?php
        $xPanel::end();
    ?>
</div>
