<?php
    
    use yii\helpers\Html;
    use yii\widgets\ActiveForm;
    use kartik\select2\Select2;
    use yii\helpers\Url;
    use yii\web\JsExpression;
    
    /* @var $this yii\web\View */
    /* @var $model artbox\stock\models\VariantToShop */
    /* @var $form yii\widgets\ActiveForm */
    /* @var $shop artbox\stock\models\Shop */
?>

<div class="variant-to-shop-form">
    
    <?php $form = ActiveForm::begin(); ?>
    
    <?= Select2::widget(
        [
            'name'          => 'VariantToShop[variant_id]',
            'value'         => ( isset($model->variant->id) ) ? array_keys([ $model->variant->id ]) : [],
            'data'          => ( isset($model->variant->sku) ) ? [ $model->variant->sku ] : [],
            'options'       => [
                'placeholder' => 'Выберите товар по коду ...',
                'multiple'    => false,
                'disabled'    => ( isset($model->variant->id) and isset($model->variant->sku) ) ? true : false,
            ],
            'pluginOptions' => [
                'allowClear'        => true,
                'ajax'              => [
                    'url'      => Url::to([ '/variant-count/list' ]),
                    'dataType' => 'json',
                    'data'     => new JsExpression(
                        'function(params) {
                                    return {
                                        q:params.term,shop_id:' . $shop->id . '
                                    };
                                 }'
                    ),
                ],
                'escapeMarkup'      => new JsExpression(
                    'function (markup) {
                                return markup;
                             }'
                ),
                'templateResult'    => new JsExpression(
                    'function (variant) {
                                return variant.text;
                             }'
                ),
                'templateSelection' => new JsExpression(
                    'function (variant) {
                                return variant.text;
                             }'
                ),
            ],
        ]
    ); ?>
    
    <?= $form->field($model, 'shop_id')
             ->hiddenInput(
                 [
                     'value' => $shop->id,
                     'id'    => 'shop_id',
                 ]
             )
             ->label(false); ?>
    
    <?= $form->field($model, 'count')
             ->textInput() ?>
  
  <div class="form-group">
      <?= Html::submitButton(
          $model->isNewRecord ? \Yii::t('stock', 'Create') : \Yii::t('stock', 'Update'),
          [ 'class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary' ]
      ) ?>
  </div>
    
    <?php ActiveForm::end(); ?>

</div>
