<?php
    
    use yii\helpers\Html;
    use yii\widgets\DetailView;
    use yiister\gentelella\widgets\Panel;
    
    /* @var $this yii\web\View */
    /* @var $model artbox\stock\models\VariantToShop */
    
    $this->title = $model->variant->sku;
    $this->params[ 'breadcrumbs' ][] = [
        'label' => \Yii::t('stock', 'Variant Count'),
        'url'   => [
            'index',
            'shop_id' => $model->shop_id,
        ],
    ];
    $this->params[ 'breadcrumbs' ][] = $this->title;
?>
<div class="variant-to-shop-view">
    <?php
        $xPanel = Panel::begin(
            [
                'header' => \Yii::t('stock', Html::encode($this->title)),
            ]
        );
    ?>
  <h1><?= Html::encode($this->title) ?></h1>
  
  <p>
      <?= Html::a(
          \Yii::t('stock', 'Update'),
          [
              'update',
              'variant_id' => $model->variant_id,
              'shop_id'    => $model->shop_id,
          ],
          [ 'class' => 'btn btn-primary' ]
      ) ?>
      <?= Html::a(
          \Yii::t('stock', 'Delete'),
          [
              'delete',
              'variant_id' => $model->variant_id,
              'shop_id'    => $model->shop_id,
          ],
          [
              'class' => 'btn btn-danger',
              'data'  => [
                  'confirm' => 'Are you sure you want to delete this item?',
                  'method'  => 'post',
              ],
          ]
      ) ?>
  </p>
    
    <?= DetailView::widget(
        [
            'model' => $model,
            'attributes' => [
                'variant.sku',
                'shop.lang.address',
                'count',
            ],
        ]
    ) ?>
    <?php
        $xPanel::end();
    ?>
</div>
