<?php
    use artbox\core\components\SeoUrlManager;
    use artbox\core\models\Page;
    use common\components\Sitemap;
    
    $params = array_merge(
        require( __DIR__ . '/../../common/config/params.php' ),
        require( __DIR__ . '/../../common/config/params-local.php' ),
        require( __DIR__ . '/params.php' ),
        require( __DIR__ . '/params-local.php' )
    );
    
    return [
        'id'                  => 'app-backend',
        'homeUrl'             => '/admin',
        'basePath'            => dirname(__DIR__),
        'controllerNamespace' => 'backend\controllers',
        'bootstrap'           => [ 'log' ],
        'controllerMap'       => [
            'profile'                            => 'artbox\core\controllers\ProfileController',
            'page'                               => 'artbox\core\controllers\PageController',
            'page-category'                      => 'artbox\core\controllers\PageCategoryController',
            'alias'                              => 'artbox\core\controllers\AliasController',
            'seo'                                => 'artbox\core\controllers\SeoController',
            'feedback'                           => 'artbox\core\controllers\FeedbackController',
        ],
        'components'          => [
            'assetManager'       => [
                'bundles'         => [
                    'yiister\gentelella\assets\ThemeAsset' => [
                        'basePath' => '@webroot',
                        'baseUrl'  => '@web',
                        'js'       => [
                            'js/custom.js',
                        ],
                        'css'      => [
                            'css/custom.css',
                        ],
                    ],
                ],
                'appendTimestamp' => true,
            ],
            'request'            => [
                'csrfParam' => '_csrf-backend',
                'baseUrl'   => '/admin',
            ],
            'user'               => [
                'identityClass'   => 'artbox\core\models\User',
                'enableAutoLogin' => true,
                'identityCookie'  => [
                    'name'     => '_identity-backend',
                    'httpOnly' => true,
                ],
            ],
            'session'            => [
                // this is the name of the session cookie used for login on the backend
                'name' => 'advanced-backend',
            ],
            'log'                => [
                'traceLevel' => YII_DEBUG ? 3 : 0,
                'targets'    => [
                    [
                        'class'  => 'yii\log\FileTarget',
                        'levels' => [
                            'error',
                            'warning',
                        ],
                    ],
                ],
            ],
            'errorHandler'       => [
                'errorAction' => 'site/error',
            ],
            'urlManager'         => [
                'enablePrettyUrl' => true,
                'showScriptName'  => false,
                'rules'           => [],
            ],
            'urlManagerFrontend' => [
                'class'           => SeoUrlManager::className(),
                'baseUrl'         => '/',
                'enablePrettyUrl' => true,
                'showScriptName'  => false,
                'rules'           => [],
            ],
            'sitemap'            => [
                'class'    => Sitemap::className(),
                'entities' => [
                    [
                        'class'      => Page::className(),
                        'conditions' => [
                            [ 'in_menu' => 1 ],
                        ],
                        'url'        => 'page/view',
                    ],
                ],
            ],
        ],
        'params'              => $params,
    ];
