<?php
    namespace backend\controllers;
    
    use common\models\Mail;
    use common\models\Settings;
    use yii\base\InvalidConfigException;
    use yii\filters\AccessControl;
    use yii\web\Controller;
    use Yii;
    
    /**
     * Class SettingsController
     *
     * @package artbox\core\controllers
     */
    class SettingsController extends Controller
    {
        /**
         * @inheritdoc
         */
        public function behaviors()
        {
            return [
                'access' => [
                    'class' => AccessControl::className(),
                    'rules' => [
                        [
                            'actions' => [
                                'login',
                                'error',
                            ],
                            'allow'   => true,
                        ],
                        [
                            'allow' => true,
                            'roles' => [ '@' ],
                        ],
                    ],
                ],
            ];
        }
        
        /**
         * Display site settings page
         *
         * @return string|\yii\web\Response
         */
        public function actionIndex()
        {
            $model = $this->findSettings();
            $mail = Mail::findOne(1);
            
            if ($mail->load(\Yii::$app->request->post())) {
                $mail->save();
            }
            
            if ($model->load(Yii::$app->request->post()) && $model->save()) {
                Yii::$app->session->setFlash('success', \Yii::t('core', 'Settings saved'));
                
                return $this->goHome();
            }
            
            return $this->render(
                'settings',
                [
                    'model' => $model,
                    'mail' => $mail,
                ]
            );
        }
    
        /**
         * Action that intended to change Robots.txt of website
         *
         * @return string
         */
        public function actionRobots()
        {
            $model = $this->findSettings();
            $model->scenario = Settings::SCENARIO_ROBOTS;
    
            if ($model->load(\Yii::$app->request->post()) && $model->save()) {
                \Yii::$app->session->setFlash('success', \Yii::t('core', 'Robots saved'));
            }
    
            return $this->render(
                'robots',
                [
                    'model' => $model,
                ]
            );
        }
    
        /**
         * Action that intended to change Google Analytics, Yandex Metrics and Tag Manager codes.
         *
         * @return string
         */
        public function actionCodes()
        {
            $model = $this->findSettings();
            $model->scenario = Settings::SCENARIO_CODES;
        
            if ($model->load(\Yii::$app->request->post()) && $model->save()) {
                \Yii::$app->session->setFlash('success', \Yii::t('core', 'Codes saved successfully'));
            }
        
            return $this->render(
                'codes',
                [
                    'model' => $model,
                ]
            );
        }
        
        /**
         * Find site settings
         *
         * @return \yii2tech\filedb\ActiveRecord
         * @throws \yii\base\InvalidConfigException
         */
        public function findSettings()
        {
            if ($model = Settings::find()
                                 ->one()
            ) {
                return $model;
            } else {
                throw new InvalidConfigException('Settings file not found');
            }
        }
    }
    