<?php
    namespace backend\controllers;
    
    use common\components\Sitemap;
    use common\models\SitemapDynamic;
    use common\models\SitemapStatic;
    use yii\bootstrap\ActiveForm;
    use yii\bootstrap\Html;
    use yii\filters\AccessControl;
    use yii\helpers\Json;
    use yii\web\Controller;
    
    /**
     * Class SitemapController
     */
    class SitemapController extends Controller
    {
        /**
         * @inheritdoc
         */
        public function behaviors()
        {
            return [
                'access' => [
                    'class' => AccessControl::className(),
                    'rules' => [
                        [
                            'actions' => [
                                'login',
                                'error',
                            ],
                            'allow'   => true,
                        ],
                        [
                            'allow' => true,
                            'roles' => [ '@' ],
                        ],
                    ],
                ],
            ];
        }
        
        /**
         * Action to configure sitemap of the website
         *
         * @return string
         */
        public function actionIndex()
        {
            return $this->render('index');
        }
        
        /**
         * Action to configure sitemap of the website
         *
         * @return string
         */
        public function actionUpdate()
        {
            /**
             * @var Sitemap $sitemap
             */
            $request = \Yii::$app->request;
            // ***** Generate SitemapDynamic models for every entity in Sitemap component
            $sitemap = \Yii::$app->get('sitemap');
            $entities = $sitemap->entities;
            /**
             * @var SitemapDynamic[] $entity_models
             */
            $entity_models = [];
            foreach ($entities as $entity) {
                $entity_model = new SitemapDynamic();
                $entity_model->entity = $entity[ 'class' ];
                $entity_model->status = SitemapDynamic::STATUS_DISABLED;
                $entity_models[] = $entity_model;
            }
            // ***** <<< End
            if ($request->isPost) {
                $success = false;
                // ***** Create SitemapStatic models from POST and delete existing
                $models = [];
                $index = 1;
                foreach ($request->post('SitemapStatic') as $item) {
                    $model = new SitemapStatic();
                    if ($model->load($item, '') && $model->validate()) {
                        $model->id = $index++;
                        $models[] = $model;
                    }
                }
                if (!empty( $models )) {
                    $old = SitemapStatic::find()
                                        ->all();
                    foreach ($old as $item) {
                        $item->delete();
                    }
                    foreach ($models as $model) {
                        $model->save(false);
                        $success = true;
                    }
                }
                // ***** <<< End
                // ***** Create SitemapDynamic models from POST and delete existing
                
                /**
                 * @var SitemapDynamic[] $old_entity_models
                 */
                $old_entity_models = SitemapDynamic::find()
                                                   ->all();
                foreach ($old_entity_models as $old_entity_model) {
                    $old_entity_model->delete();
                }
                $index = 1;
                $entity_models = [];
                foreach ($request->post('SitemapDynamic') as $item) {
                    $entity = new SitemapDynamic();
                    if ($entity->load($item, '') && $entity->validate()) {
                        $entity->id = $index++;
                        $entity->save(false);
                        $entity_models[] = $entity;
                        $success = true;
                    }
                }
                if ($success) {
                    if ($request->post('action', '') == 'generate') {
                        if ($sitemap->generateXML()) {
                            \Yii::$app->session->setFlash(
                                'success',
                                \Yii::t(
                                    'core',
                                    'Sitemap generated to ' . \Yii::getAlias(
                                        $sitemap->path . '.'
                                    )
                                )
                            );
                        }
                    }
                    return $this->redirect([ 'index' ]);
                }
                // ***** <<< End
            } else {
                // ***** Find existing SitemapStatic models
                $models = SitemapStatic::find()
                                       ->all();
                if (empty( $models )) {
                    $models = [ new SitemapStatic() ];
                }
                // ***** <<< End
                // ***** Fill SitemapDynamic models from Sitemap component with existing models
                /**
                 * @var SitemapDynamic[] $old_entity_models
                 */
                $old_entity_models = SitemapDynamic::find()
                                                   ->indexBy('entity')
                                                   ->all();
                foreach ($entity_models as $index => $entity_model) {
                    if (isset( $old_entity_models[ $entity_model->entity ] )) {
                        $entity_model->status = $old_entity_models[ $entity_model->entity ]->status;
                        $entity_model->priority = $old_entity_models[ $entity_model->entity ]->priority;
                        $entity_model->frequency = $old_entity_models[ $entity_model->entity ]->frequency;
                    }
                }
                // ***** <<< End
            }
            return $this->render(
                'update',
                [
                    'models'        => $models,
                    'entity_models' => $entity_models,
                ]
            );
        }
        
        /**
         * Create activeField for static sitemap
         *
         * @return string
         */
        public function actionCreateStatic()
        {
            $content = '';
            $request = \Yii::$app->request;
            $formId = $request->get('formId');
            $count = $request->get('count');
            if (empty( $formId ) || empty( $count )) {
                return $this->renderContent($content);
            }
            $model = new SitemapStatic();
            $form = new ActiveForm();
            $content .= $form->field(
                $model,
                "[$count]url",
                [
                    'options' => [
                        'class' => 'form-group col-xs-5 col-sm-6',
                    ],
                ]
            )
                             ->textInput()
                             ->render();
            $content .= $form->field(
                $model,
                "[$count]frequency",
                [
                    'options' => [
                        'class' => 'form-group col-xs-3 col-sm-3',
                    ],
                ]
            )
                             ->dropDownList(
                                 [
                                     'always'  => 'always',
                                     'hourly'  => 'hourly',
                                     'daily'   => 'daily',
                                     'weekly'  => 'weekly',
                                     'monthly' => 'monthly',
                                     'yearly'  => 'yearly',
                                     'never'   => 'never',
                                 ]
                             )
                             ->render();
            $content .= $form->field(
                $model,
                "[$count]priority",
                [
                    'options' => [
                        'class' => 'form-group col-xs-3 col-sm-2',
                    ],
                ]
            )
                             ->textInput()
                             ->render();
            $content .= Html::icon(
                'minus',
                [
                    'class'   => 'col-xs-1 field-group-remove',
                    'onclick' => 'sitemap_remove(this)',
                ]
            );
            foreach ($form->attributes as $index => $attribute) {
                $content .= Html::script("$('#w0').yiiActiveForm('add', " . Json::htmlEncode($attribute) . ");");
            }
            $content = Html::tag(
                'div',
                $content,
                [
                    'class' => 'row field-group',
                ]
            );
            $this->layout = false;
            return $this->renderContent($content);
        }
        
        /**
         * Generate sitemap XML to Sitemap::$path
         *
         * @return bool
         */
        public function actionGenerate()
        {
            $response = \Yii::$app->response;
            $response->format = $response::FORMAT_JSON;
            /**
             * @var Sitemap $sitemap
             */
            $sitemap = \Yii::$app->get('sitemap');
            return $sitemap->generateXML();
        }
    }
    