<?php
    /**
     * @var View     $this
     * @var Settings $model
     * @var Mail     $mail
     */
    
    use common\models\Mail;
    use common\models\Settings;
    use yii\bootstrap\ActiveForm;
    use yii\bootstrap\Html;
    use yii\bootstrap\Tabs;
    use yii\web\View;
    use yiister\gentelella\widgets\Panel;
    
    $this->title = 'Settings';
    
    $this->params[ 'breadcrumbs' ][] = $this->title;
?>

<?php $panel = Panel::begin(
    [
        'header' => $this->title,
    ]
); ?>

<div class="settings-form">
    
    <?php
        $form = ActiveForm::begin();
        
        echo Tabs::widget(
            [
                'options' => [
                    'class' => 'bar_tabs',
                ],
                'items'   => [
                    [
                        'label'   => \Yii::t('core', 'Main'),
                        'content' => $this->render(
                            '_main_tab',
                            [
                                'model' => $model,
                                'form'  => $form,
                            ]
                        ),
                    ],
                    [
                        'label'   => \Yii::t('core', 'Contact'),
                        'content' => $this->render(
                            '_contact_tab',
                            [
                                'model' => $model,
                                'form'  => $form,
                            ]
                        ),
                    ],
                    [
                        'label'   => \Yii::t('core', 'Social'),
                        'content' => $this->render(
                            '_social_tab',
                            [
                                'model' => $model,
                                'form'  => $form,
                            ]
                        ),
                    ],
                    [
                        'label'   => \Yii::t('core', 'Codes'),
                        'content' => $this->render(
                            '_codes_tab',
                            [
                                'model' => $model,
                                'form'  => $form,
                            ]
                        ),
                    ],
                    [
                        'label'   => \Yii::t('core', 'Email'),
                        'content' => $this->render(
                            '_mail_tab',
                            [
                                'form' => $form,
                                'mail' => $mail,
                            ]
                        ),
                    ],
                ],
            ]
        );
        
        echo Html::submitButton(
            'Save',
            [
                'class' => 'btn btn-primary',
            ]
        );
        ActiveForm::end();
    ?>

</div>

<?php $panel::end(); ?>
