<?php
    
    /**
     * @var string        $content
     * @var \yii\web\View $this
     * @var LoginForm     $model
     */
    
    use common\models\LoginForm;
    use hiqdev\assets\icheck\iCheckAsset;
    use yii\helpers\Html;
    use yii\web\View;
    use yii\widgets\ActiveForm;
    
    $bundle = yiister\gentelella\assets\Asset::register($this);
    
    $this->title = 'Логин';
    
    iCheckAsset::register($this);
    $js = <<< JS
$('input').iCheck({
checkboxClass: 'icheckbox_square-blue',
increaseArea: '20%' // optional
});
JS;
    $this->registerJs($js, View::POS_READY);
?>
<?php $this->beginPage(); ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta charset="<?= Yii::$app->charset ?>"/>
        <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
        <meta name="viewport" content="width=device-width, initial-scale=1"/>
        <?= Html::csrfMetaTags() ?>
        <title><?= Html::encode($this->title) ?></title>
        <?php $this->head() ?>
    </head>
    <body>
        <?php $this->beginBody(); ?>
        <div class="container" style="background-color: #F7F7F7; height: 100%">
            <div class="row" style="margin-top: 10%">
                <div class="col-md-4 col-md-offset-4">
                    
                    
                    <div class="site-login x_panel">
                        <div class="x_title">
                            <h1><?= Html::encode($this->title) ?></h1>
                            
                            <p>Please fill out the following fields to login:</p>
                        </div>
                        <div class="row">
                            <div>
                                <?php $form = ActiveForm::begin(
                                    [
                                        'id'             => 'login-form',
                                        'validateOnBlur' => false,
                                    ]
                                ); ?>
                                
                                <?= $form->field($model, 'username')
                                         ->textInput([ 'autofocus' => true ]) ?>
                                
                                <?= $form->field($model, 'password')
                                         ->passwordInput() ?>
                                
                                <?= $form->field($model, 'rememberMe')
                                         ->checkbox() ?>
                                
                                <div class="form-group">
                                    <?= Html::submitButton(
                                        'Login',
                                        [
                                            'class' => 'btn btn-default',
                                            'name'  => 'login-button',
                                        ]
                                    ) ?>
                                </div>
                                
                                <?php ActiveForm::end(); ?>
                            </div>
                        </div>
                    </div>
                
                
                </div>
            </div>
        
        </div>
        <?php $this->endBody(); ?>
    </body>
</html>
<?php $this->endPage(); ?>

