<?php
    namespace common\models;
    
    use Yii;
    use yii\helpers\ArrayHelper;
    use yii2tech\filedb\ActiveRecord;
    
    /**
     * Class SitemapDynamic
     *
     * @property int    $id
     * @property string $entity
     * @property bool   $status
     * @property float  $priority
     * @property string $frequency
     */
    class SitemapDynamic extends ActiveRecord
    {
        
        const STATUS_ENABLED = 1;
        const STATUS_DISABLED = 0;
        
        /**
         * @inheritdoc
         */
        public static function getDb()
        {
            return \Yii::$app->get('sitemapdb');
        }
        
        /**
         * @inheritdoc
         */
        public function attributes()
        {
            return [
                'id',
                'entity',
                'status',
                'priority',
                'frequency',
            ];
        }
        
        /**
         * @inheritdoc
         */
        public static function primaryKey()
        {
            return [ 'id' ];
        }
        
        /**
         * @inheritdoc
         */
        public function rules()
        {
            return [
                [
                    [
                        'entity',
                        'status',
                        'priority',
                        'frequency',
                    ],
                    'required',
                ],
                [
                    [
                        'status',
                    ],
                    'boolean',
                ],
                [
                    [
                        'entity',
                        'frequency',
                    ],
                    'string',
                ],
                [
                    [
                        'priority',
                    ],
                    'double',
                    'min' => 0,
                    'max' => 1,
                ],
            ];
        }
        
        /**
         * @inheritdoc
         */
        public function attributeLabels()
        {
            return [
                'id'        => Yii::t('core', 'ID'),
                'entity'    => Yii::t('core', 'Model'),
                'status'    => Yii::t('core', 'Status'),
                'priority'  => Yii::t('core', 'Priority'),
                'frequency' => Yii::t('core', 'Frequency'),
            ];
        }
        
        /**
         * Find maximum ID value from SitemapStatic models
         */
        public static function max(): int
        {
            $models = self::find()
                          ->all();
            $array = ArrayHelper::getColumn($models, self::primaryKey()[ 0 ], false);
            if (empty( $array )) {
                return 0;
            } else {
                return max($array);
            }
        }
    }