<?php
    namespace console\controllers;

    use artbox\core\models\User;
    use yii\console\Controller;
    use yii\helpers\Console;

    /**
     * Class CreateController
     *
     * @package console\controllers
     */
    class CreateController extends Controller
    {
        public function actionUser($username = null, $email = null, $password = null)
        {
            $username = $username ? : 'admin';
            $user = User::find()
                        ->where([ 'username' => $username ])
                        ->one();
            if (empty( $user )) {
                $user = new User();
                $user->username = $username;
            }
            $user->email = $email ? : 'admin@example.com';
            $user->setPassword($password ? : 'admin321');
            $user->generateAuthKey();
    
            if ($user->save()) {
                if ($user->isNewRecord) {
                    $this->stdout('User created' . "\n", Console::FG_GREEN);
                } else {
                    $this->stdout('User updated' . "\n", Console::FG_GREEN);
                }
            } else {
                $this->stdout('Error!' . "\n", Console::FG_RED);
                return self::EXIT_CODE_ERROR;
            }
            return self::EXIT_CODE_NORMAL;
        }
    }