<?php
    namespace frontend\controllers;
    
    use common\models\Feedback;
    use common\models\Settings;
    use Yii;
    use yii\filters\VerbFilter;
    use yii\swiftmailer\Mailer;
    use yii\web\BadRequestHttpException;
    use yii\web\Controller;
    use yii\web\Response;
    
    /**
     * Site controller
     */
    class SiteController extends Controller
    {
        /**
         * @inheritdoc
         */
        public function actions()
        {
            return [
                'error' => [
                    'class' => 'yii\web\ErrorAction',
                ],
            ];
        }
        
        /**
         * @inheritdoc
         */
        public function behaviors()
        {
            return [
                'verbs' => [
                    'class'   => VerbFilter::className(),
                    'actions' => [
                        'feedback' => [ 'post' ],
                    ],
                ],
            ];
        }
        
        /**
         * Displays homepage.
         *
         * @return mixed
         */
        public function actionIndex()
        {
            return $this->render('index');
        }
        
        /**
         * Displays contact page.
         *
         * @return mixed
         */
        public function actionContact()
        {
            $contact = new Feedback();
            return $this->render(
                'contact',
                [
                    'contact' => $contact,
                ]
            );
        }
        
        /**
         * Displays about page.
         *
         * @return mixed
         */
        public function actionAbout()
        {
            return $this->render('about');
        }
        
        /**
         * Action to view robots.txt file dinamycli
         *
         * @return string
         */
        public function actionRobots()
        {
            $response = \Yii::$app->response;
            /**
             * @var Settings $settings
             */
            $settings = Settings::find()
                                ->one();
            $temp = tmpfile();
            fwrite($temp, $settings->robots);
            $meta = stream_get_meta_data($temp);
            $response->format = $response::FORMAT_RAW;
            $response->headers->set('Content-Type', 'text/plain');
            return $this->renderFile($meta[ 'uri' ]);
        }
        
        public function actionFeedback()
        {
            Yii::$app->response->format = Response::FORMAT_JSON;
            
            /**
             * @var Mailer $mailer
             */
            $mailer = \Yii::$app->get('smtpmailer');
            $settings = Settings::getInstance();
            
            if (empty(Yii::$app->request->post())) {
                throw new BadRequestHttpException();
            } else {
                $def = Yii::$app->request->post('def');
                if ( isset($def) ){
                    $model = new Feedback(['scenario'=>Feedback::SCENARIO_DEFAULT]);
                }
                else{
                    $model = new Feedback(['scenario'=>Feedback::SCENARIO_FEEDBACK]);
                }
                
                if ($model->load(Yii::$app->request->post()) && $model->save()) {
                    
                    $mailer->compose(
                        'feedback',
                        [
                            'model' => $model,
                        ]
                    )
                           ->setFrom(['artwebdev17@gmail.com'=> 'artweb'])
                           ->setTo(
                               [
                                   'kotets.nik@gmail.com',
                                   'kazimirova.artweb@gmail.com',
//                                   'tamerlan8.05.92@gmail.com',
                               ]
                           )
                           ->setSubject('Bitcoin Invest участие в форуме')
                           ->send();
                    
                    return [
                        'success' => true,
                        'message' => 'Success message',
                        'alert'   => '<div class="alert alert-success">
            <h3>Success</h3>
            <p>
              Success text
            </p>
          </div>',
                    ];
                } else {
                    Yii::$app->response->setStatusCode(500);
                    return [
                        'success' => false,
                        'error'   => $model->errors,
                    ];
                }
            }
        }
    }
