<?php
    
    /**
     * @var View     $this
     * @var Feedback $contact
     */
    
    use artbox\core\models\Feedback;
    use common\models\Settings;
    use frontend\assets\MapAsset;
    use yii\helpers\Html;
    use yii\bootstrap\ActiveForm;
    use yii\web\View;
    
    MapAsset::register($this);
    $settings = Settings::getInstance();
    
    $this->title = \Yii::t('app', 'Contact');
    $this->params[ 'breadcrumbs' ][] = $this->title;
    
    $js = <<< JS
window.lat = {$settings->lat};
window.lon = {$settings->lon};
JS;
    
    $this->registerJs($js, View::POS_END);
?>

<div id="content">
    <div class="container" id="contact">
        
        <section>
            
            <div class="row">
                <div class="col-md-12">
                    <section>
                        <div class="heading">
                            <h2>We are here to help you</h2>
                        </div>
                        
                        <p class="lead">Are you curious about something? Do you have some kind of problem with our products? As am hastily invited settled at limited civilly fortune me. Really spring in extent an by. Judge but built gay party world. Of so am
                            he remember although required. Bachelor unpacked be advanced at. Confined in declared marianne is vicinity.</p>
                        <p>Please feel free to contact us, our customer service center is working for you 24/7.</p>
                    </section>
                </div>
            </div>
        
        </section>
        <section>
            
            <div class="row">
                <div class="col-md-4">
                    <div class="box-simple">
                        <div class="icon">
                            <i class="fa fa-map-marker"></i>
                        </div>
                        <h3>Address</h3>
                        <p>
                            <?php
                                if (!empty( $settings->street )) {
                                    echo $settings->street;
                                    if (!empty( $settings->house )) {
                                        echo " " . $settings->house;
                                    }
                                    echo Html::tag('br');
                                }
                                if (!empty( $settings->city )) {
                                    echo $settings->city;
                                    if (!empty( $settings->country )) {
                                        echo Html::tag('strong', ", " . $settings->country);
                                    }
                                }
                            ?>
                        </p>
                    </div>
                    <!-- /.box - simple-->
                </div>
                
                
                <div class="col-md-4">
                    <?php
                        if (!empty( $settings->phone )) {
                            ?>
                            <div class="box-simple">
                                <div class="icon">
                                    <i class="fa fa-phone"></i>
                                </div>
                                <h3> Call center </h3>
                                <p class="text-muted"> This number is toll free if calling from Great Britain otherwise we advise you to use the electronic form of communication .</p>
                                <p>
                                    <?php
                                        echo Html::a(Html::tag('strong', $settings->phone), 'tel:' . $settings->phone);
                                    ?>
                                </p>
                            </div>
                            <!-- /.box - simple-->
                            <?php
                        }
                    ?>
                </div>
                
                <?php
                    if (!empty( $settings->email )) {
                        ?>
                        <div class="col-md-4">
                            
                            <div class="box-simple">
                                <div class="icon">
                                    <i class="fa fa-envelope"></i>
                                </div>
                                <h3> Electronic support </h3>
                                <p class="text-muted"> Please feel free to write an email to us or to use our electronic ticketing system .</p>
                                <ul class="list-style-none">
                                    <li>
                                        <?php
                                            echo Html::a(
                                                Html::tag('strong', $settings->email),
                                                'mailto:' . $settings->email
                                            );
                                        ?>
                                    </li>
                                </ul>
                            </div>
                            <!-- /.box - simple-->
                        </div>
                        <?php
                    }
                ?>
            </div>
        
        </section>
        
        <section>
            
            <div class="row text-center">
                
                <div class="col-md-12">
                    <div class="heading">
                        <h2> Contact form </h2>
                    </div>
                </div>
                
                <div class="col-md-8 col-md-offset-2">
                    <?php $form = ActiveForm::begin(
                        [
                            'id' => 'contact-form',
                            'method' => 'POST',
                            'action' => '/site/feedback',
                        ]
                    ); ?>
                    <div class="row">
                        <div class="col-sm-12">
                            <?= $form->field($contact, 'name')
                                     ->textInput(); ?>
                        </div>
                        
                        <div class="col-sm-6">
                            <?= $form->field($contact, 'email')
                                     ->textInput(); ?>
                        </div>
                        <div class="col-sm-6">
                            <?= $form->field($contact, 'phone')
                                     ->textInput(); ?>
                        </div>
                        <div class="col-sm-12">
                            <?= $form->field($contact, 'message')
                                     ->textarea(
                                         [
                                             'rows' => 3,
                                         ]
                                     ); ?>
                        </div>
                        
                        <div class="col-sm-12 text-center">
                            <?= Html::submitButton(
                                '<i class="fa fa-envelope-o"></i> Send message',
                                [
                                    'class' => 'btn btn-template-main',
                                ]
                            ) ?>
                        
                        </div>
                    </div>
                    <!-- /.row -->
                    <?php ActiveForm::end(); ?>
                </div>
            </div>
            <!-- /.row -->
        
        </section>
    
    
    </div>
    <!-- /#contact.container -->
</div>
<!-- /#content -->

<div id="map">

</div>